// UParser.cp
// UParser.h
// UParser.cp
// UParser.h
// ----------------------------------------------------------------------------------
// Word to Phoneme parser for the Spell checker.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
// This is from a lex compilier.  It is a subclass of UPhoneMatch and match phonemes.
//
//
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original.  Simple read/write functions.
//		Clark Goble			08/13/94
//			Made UPhoneMatch a contained object.  Before UPhoneMatch (actually under
//			a different name) was the superclass of UParser.
// ----------------------------------------------------------------------------------

#include "UParser.h"
#include <string.h>


// ----------------------------------------------------------------------------------
// YACC defines (modified somewhat)
// ----------------------------------------------------------------------------------



// ----------------------------------------------------------------------------------
//	UParser		- Parser constructor
// ----------------------------------------------------------------------------------
// The constructor creates an object for matching

UParser::UParser()
{
	yy_saw_eof = 1;
	yy_init = 1;
	

	static short aprime[298] =
    {   0,
      176,  166,  176,  165,  166,  176,  159,  166,  176,  166,
      176,  140,  166,  176,  142,  166,  176,  160,  166,  176,
      146,  166,  176,  145,  166,  176,  147,  166,  176,  161,
      166,  176,  148,  166,  176,  141,  166,  176,  149,  166,
      176,  150,  166,  176,  151,  166,  176,  162,  166,  176,
      152,  166,  176,  153,  166,  176,  154,  166,  176,  155,
      166,  176,  143,  166,  176,  163,  166,  176,  156,  166,
      176,  157,  166,  176,  158,  166,  176,  164,  166,  176,
      144,  166,  176,  176,  176,  176,  176,   63,  176,   57,
       63,  176,   40,   63,  176,   36,   63,  176,   41,   63,

      176,   58,   63,  176,   42,   63,  176,   37,   63,  176,
       43,   63,  176,   59,   63,  176,   44,   63,  176,   38,
       63,  176,   45,   63,  176,   46,   63,  176,   47,   63,
      176,   60,   63,  176,   48,   63,  176,   49,   63,  176,
       50,   63,  176,   51,   63,  176,   52,   63,  176,   61,
       63,  176,   53,   63,  176,   54,   63,  176,   55,   63,
      176,   62,   63,  176,   39,   56,   63,  176,  134,   65,
       67,   69,   68,   66,   89,  115,   73,   77,   70,   71,
       86,   87,   79,   80,   83,  103,  107,  105,   90,   91,
      106,   92,   93,   78,   96,   99,  138,  100,  101,  102,

      108,   81,  109,  121,  110,   95,  111,  113,  124,  125,
       98,  119,  122,  120,  131,  135,  133,   75,  132,  136,
      137,  114,   97,  139,  174,  169,  173,  174,  175,  175,
      171,  173,  174,  174,  168,  174,  173,  174,  167,  175,
       23,    1,   24,   25,    2,    6,   10,    8,   14,   35,
       11,   15,   13,   16,    7,   17,   30,   20,   12,   18,
       31,   29,   21,    3,   22,    4,   34,   19,   33,   64,
       88,   76,   72,   84,  104,   82,   94,  112,  116,  123,
      117,  118,  130,  126,  127,   74,  128,   85,  129,  170,
      172,   26,   32,   27,   28,    5,    9

    } ;
    
    a = aprime;

	static short lprime[202] =
    {   0,
       -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,    1,    2,
        4,    7,   10,   12,   15,   18,   21,   24,   27,   30,
       33,   36,   39,   42,   45,   48,   51,   54,   57,   60,
       63,   66,   69,   72,   75,   78,   81,   84,   85,   86,
       87,   88,   90,   93,   96,   99,  102,  105,  108,  111,
      114,  117,  120,  123,  126,  129,  132,  135,  138,  141,
      144,  147,  150,  153,  156,  159,  162,  165,  169,  170,
      171,  172,  173,  174,  175,  175,  176,  177,  178,  179,
      180,  181,  182,  183,  184,  185,  186,  186,  187,  188,
      188,  189,  190,  191,  192,  193,  194,  195,  196,  197,

      198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
      208,  209,  209,  210,  211,  212,  213,  214,  215,  215,
      216,  216,  217,  218,  219,  220,  221,  222,  223,  224,
      224,  225,  226,  229,  230,  231,  234,  235,  237,  239,
      241,  242,  243,  244,  245,  246,  247,  248,  249,  250,
      251,  252,  253,  254,  255,  256,  257,  258,  259,  260,
      261,  261,  262,  263,  263,  264,  265,  266,  267,  268,
      269,  270,  271,  272,  273,  274,  275,  276,  277,  278,
      279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
      289,  290,  291,  292,  293,  294,  295,  296,  297,  298,

      298
    } ;
    
    l = lprime;

	static short bprime[205] =
    {   0,
        0,    0,    0,  114,   28,   29,  227,  340,  970,  970,
      970,  970,  195,   52,   38,  970,   45,   59,  200,  970,
      970,   68,   77,   72,  194,  970,   76,  178,   23,  139,
      146,  970,  970,   44,   55,  970,  155,  155,  170,  177,
      188,  970,  970,  970,  179,   90,  970,  970,  192,  970,
      970,  970,   89,  165,  160,  970,  970,   94,  152,  153,
      160,  193,  970,  970,   86,  970,  970,  131,  970,  145,
      970,  970,  970,  970,  131,  970,  970,  970,  142,  970,
      970,  970,  970,  970,  970,  970,  233,  970,  970,  140,
      130,  970,  970,  970,  970,  970,  970,  970,  970,  970,

      970,  970,  970,  970,  970,  135,  970,  970,  107,  970,
      103,   31,  970,   95,  970,   26,  970,  970,  101,  970,
       92,  970,  970,  970,  970,  970,   91,  970,  970,   90,
      970,  970,  970,  970,  180,  970,  162,  970,  970,  970,
      970,  970,  970,  970,  970,  970,  970,  970,  970,  970,
      970,  970,  970,  970,  970,  970,  970,  970,  970,  970,
      202,  970,  970,   62,  970,  970,  970,  970,   17,  970,
      970,  970,  970,  970,  970,  970,  970,  970,  970,  970,
      970,  970,  970,  970,  970,  970,  970,  970,  970,  970,
      970,  970,  970,  970,  970,  970,  970,  970,  970,  970,

      462,  589,  716,  843
    } ;
    
    b = bprime;

	static short dprime[205] =
    {   0,
      201,  201,  202,  202,  201,  201,  203,  203,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  204,  204,  204,
      204,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,

      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,-32767,

      200,  200,  200,  200
    } ;
    
    d = dprime;

	static short nprime[1098] =
    {   0,
      200,  200,  200,  200,  200,  200,  200,  200,   11,    9,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,   12,   13,   14,   15,

       16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
       26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
       36,   37,   11,    9,   38,   38,  110,  199,   39,   39,
      186,  181,   40,   40,  182,  183,  111,   79,   41,   41,
       80,   81,  187,   82,   40,   40,   84,  127,   40,   40,
       70,  184,   71,  129,   83,   72,   73,  128,   74,  130,
       85,   86,   87,  133,   75,  198,   76,   88,   89,  101,
      193,   92,   77,   78,   93,   90,   97,   94,  136,  105,
      102,  103,   95,   98,   99,  139,   96,  106,  192,  169,
      107,  108,  151,  146,  100,  147,  139,  155,  152,  170,

      191,  190,  189,  156,  188,  185,  180,  179,  157,  158,
       12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
       22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
       32,   33,   34,   35,   36,   37,    9,  112,  178,  177,
      176,  175,  113,  114,  119,  174,  115,  173,  172,  120,
      121,  134,  171,  116,  117,  134,  160,  118,  161,  134,
      122,  123,  124,  162,  125,  134,  134,  126,  159,  154,
      134,  134,  153,  134,  134,  135,  131,  134,  163,  141,
      134,  134,  142,  143,  134,  137,  134,  134,  134,  138,
      134,  164,  140,  134,  109,  148,  165,  134,  134,  144,

      145,  149,  194,  104,  134,  195,  196,  166,  134,   91,
       69,  167,  200,  150,  168,  200,  200,  200,  200,  200,
      200,  200,  197,   43,   44,   45,   46,   47,   48,   49,
       50,   51,   52,   53,   54,   55,   56,   57,   58,   59,
       60,   61,   62,   63,   64,   65,   66,   67,   68,    9,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,

      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,   43,   44,   45,   46,
       47,   48,   49,   50,   51,   52,   53,   54,   55,   56,
       57,   58,   59,   60,   61,   62,   63,   64,   65,   66,
       67,   68,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,

        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
		9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,

       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,

       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   42,   42,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   42,   42,

       42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
       42,   42,   42,  132,  132,  132,  132,  132,  132,  132,
      132,  132,  132,  132,  132,  132,  132,  132,  132,  132,
      132,  132,  132,  132,  132,  132,  132,  132,  132,  132,
      132,  132,  132,  132,  132,  132,  132,  132,  132,  132,
      132,  132,  132,  132,  132,  132,  132,  132,  132,  132,
      132,  132,  132,  132,  132,  132,  132,  132,  132,  132,

      132,  132,  132,  132,  132,  132,  132,  132,  132,  132,
      132,  132,  132,  132,  132,  132,  132,  132,  132,  132,
      132,  132,  132,  132,  132,  132,  132,  132,  132,  132,
      132,  132,  132,  132,  132,  132,  132,  132,  132,  132,
      132,  132,  132,  132,  132,  132,  132,  132,  132,  132,
      132,  132,  132,  132,  132,  132,  132,  132,  132,  132,
      132,  132,  132,  132,  132,  132,  132,  132,  132,  132,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,

      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200

    } ;
    
    n = nprime;

	static short cprime[1098] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    3,    3,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    3,    3,    3,    3,

        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    4,    4,    5,    6,   29,  169,    5,    6,
      116,  112,    5,    6,  112,  112,   29,   15,    5,    6,
       15,   15,  116,   15,    5,    6,   17,   34,    5,    6,
       14,  112,   14,   35,   15,   14,   14,   34,   14,   35,
       17,   18,   18,   38,   14,  164,   14,   18,   18,   24,
      137,   22,   14,   14,   22,   18,   23,   22,   39,   27,
       24,   24,   22,   23,   23,   40,   22,   27,  135,   65,
       27,   27,   53,   46,   23,   46,   41,   58,   53,   65,

      130,  127,  121,   58,  119,  114,  111,  109,   58,   58,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    7,   30,  106,   91,
       90,   87,   30,   30,   31,   79,   30,   75,   70,   31,
       31,   38,   68,   30,   30,   38,   60,   30,   61,   38,
       31,   31,   31,   61,   31,   38,   39,   31,   59,   55,
       39,   38,   54,   40,   39,   38,   37,   40,   61,   45,
       39,   40,   45,   45,   41,   39,   39,   40,   41,   39,
       39,   62,   41,   40,   28,   49,   62,   40,   41,   45,

       45,   49,  161,   25,   41,  161,  161,   62,   41,   19,
       13,   62,    0,   49,   62,    0,    0,    0,    0,    0,
        0,    0,  161,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    8,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,  201,  201,  201,  201,  201,  201,  201,  201,
      201,  201,  201,  201,  201,  201,  201,  201,  201,  201,
      201,  201,  201,  201,  201,  201,  201,  201,  201,  201,
      201,  201,  201,  201,  201,  201,  201,  201,  201,  201,

      201,  201,  201,  201,  201,  201,  201,  201,  201,  201,
      201,  201,  201,  201,  201,  201,  201,  201,  201,  201,
      201,  201,  201,  201,  201,  201,  201,  201,  201,  201,
      201,  201,  201,  201,  201,  201,  201,  201,  201,  201,
      201,  201,  201,  201,  201,  201,  201,  201,  201,  201,
      201,  201,  201,  201,  201,  201,  201,  201,  201,  201,
      201,  201,  201,  201,  201,  201,  201,  201,  201,  201,
      201,  201,  201,  201,  201,  201,  201,  201,  201,  201,
      201,  201,  201,  201,  201,  201,  201,  201,  201,  202,
      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,

      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,

      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  202,  202,  202,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,

      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,

      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,

      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  200

    } ;
    
    c = cprime;

}


// ----------------------------------------------------------------------------------
//	~UParser		- Parser destructor
// ----------------------------------------------------------------------------------
// The constructor frees the object for matching

UParser::~UParser()
{
}

// ----------------------------------------------------------------------------------
// LEX Functions for converting letters to phonemes.
// ----------------------------------------------------------------------------------

short 
UParser::B()
{
	if(TestWord == TRUE)
	{
		if(Check(P_B,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE)
	{
		Insert(P_B,PhonemePosition);
	}
	#ifdef TRACE
	printf("B");
	#endif
	return (OK);
}

short 
UParser::CH()
{
	if(TestWord == TRUE){
	if(Check(P_CH,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	 Insert(P_CH,PhonemePosition);
	}
	#ifdef TRACE
	printf("CH");
	#endif
	return (OK);
}

short UParser::D()
{
	if(TestWord == TRUE){
	if (Check(P_D,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_D,PhonemePosition);
	}
	#ifdef TRACE
	printf("D");
	#endif
	return (OK);
}

short 
UParser::F()
{
	
	if(TestWord == TRUE){
	if (Check(P_F,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_F,PhonemePosition);
	}
	#ifdef TRACE
	printf("F");
	#endif
	return (OK);
}

short 
UParser::G()
{
	if(TestWord == TRUE){
	if (Check(P_G,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_G,PhonemePosition);
	}
	#ifdef TRACE
	printf("G");
	#endif
	return (OK);
}


short 
UParser::H()
{
	if(TestWord == TRUE){
	if (Check(P_H,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_H,PhonemePosition);
	}
	#ifdef TRACE
	printf("H");
	#endif
	return (OK);
}

short 
UParser::J()
{
	if(TestWord == TRUE){
	if(Check(P_J,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_J,PhonemePosition);
	}
	#ifdef TRACE
	printf("J");
	#endif
	return (OK);
}

short 
UParser::K()
{
	if(TestWord == TRUE){
	if (Check(P_K,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_K,PhonemePosition);
	}
	#ifdef TRACE
	printf("K");
	#endif
	return (OK);
}

short UParser::L()
{
	if(TestWord == TRUE){
	if (Check(P_L,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_L,PhonemePosition);
	}
	#ifdef TRACE
	printf("L");
	#endif
	return (OK);
}

short 
UParser::M()
{
	if(TestWord == TRUE){
	if (Check(P_M,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_M,PhonemePosition);
	}
	#ifdef TRACE
	printf("M");
	#endif
	return (OK);
}

short 
UParser::N()
{
	if(TestWord == TRUE){
	if (Check(P_N,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_N,PhonemePosition);
	}
	#ifdef TRACE
	printf("N");
	#endif
	return (OK);
}

short 
UParser::P()
{
	if(TestWord == TRUE){
	if (Check(P_P,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_P,PhonemePosition);
	}
	#ifdef TRACE
	printf("P");
	#endif
	return (OK);
}

short 
UParser::R()
{
	if(TestWord == TRUE){
	if (Check(P_R,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_R,PhonemePosition);
	}
	#ifdef TRACE
	printf("R");
	#endif
	return (OK);
}

short 
UParser::S()
{
	if(TestWord == TRUE){
	if (Check(P_S,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_S,PhonemePosition);
	}
	#ifdef TRACE
	printf("S");
	#endif
	return (OK);
}

short 
UParser::SH()
{
	if(TestWord == TRUE){
	if (Check(P_SH,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	 Insert(P_SH,PhonemePosition);
	}
	#ifdef TRACE
	printf("SH");
	#endif
	return (OK);
}

short 
UParser::T()
{
	if(TestWord == TRUE){
	if (Check(P_T,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	 Insert(P_T,PhonemePosition);
	}
	#ifdef TRACE
	printf("T");
	#endif
	return (OK);
}

short 
UParser::TS()
{
	if(TestWord == TRUE){
	if(Check(P_TS,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	 Insert(P_TS,PhonemePosition);
	}
	#ifdef TRACE
	printf("TS");
	#endif
	return (OK);
}

short 
UParser::V()
{
	if(TestWord == TRUE){
	if (Check(P_V,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_V,PhonemePosition);
	}
	#ifdef TRACE
	printf("V");
	#endif
	return (OK);
}

short 
UParser::W()
{
	if(TestWord == TRUE){
	if (Check(P_W,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_W,PhonemePosition);
	}
	#ifdef TRACE
	printf("W");
	#endif
	return (OK);
}

short 
UParser::Z()
{
	if(TestWord == TRUE){
	if (Check(P_Z,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_Z,PhonemePosition);
	}
	#ifdef TRACE
	printf("Z");
	#endif
	return (OK);
}


short 
UParser::V1()
{
	if(TestWord == TRUE){
	if (Check(P_VWL,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	 Insert(P_VWL,PhonemePosition);
	}
	#ifdef TRACE
	printf("V1");
	#endif
	return (OK);
}

/*
short V0(){
	    LastVowelPosition = strlen(RegexPattern)-1;
	    strcat(RegexPattern,"([aeiouy]*)");
	    #ifdef TRACE
	    printf("V0");
	    #endif
	    }
*/

short 
UParser::Ve() 
{
	if(TestWord == TRUE){
	if (Check(P_Ve,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_Ve,PhonemePosition);
	}
	#ifdef TRACE
	printf("Ve");
	#endif
	return (OK);
}

short 
UParser::Vet()  
{
	if(TestWord == TRUE){
	if (Check(P_Ve,PhonemePosition) != FOUND) return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_Ve,PhonemePosition);
	}
	#ifdef TRACE
	printf("\nVet");
	#endif
	return (OK);
}

short 
UParser::EOW() 
{
	if(TestWord == TRUE){
	if (Check(P_EOW,PhonemePosition) == FOUND) return FOUND;
	else return NOTFOUND;
	}
	if(TestWord != TRUE){
	Insert(P_EOW,PhonemePosition);
	}
	#ifdef TRACE
	printf("\nEOW");
	#endif
	return (OK);
}



short 
UParser::InputWord(char *Buf, short MaxSize)
{
	short n;
	
	n=min(MaxSize,WordLength-WordPosition);
	
	#ifdef TRACE
	printf("\nmy_yyinput()");
	#endif
	if(n > 0) {
		memcpy(Buf,WordPointer+WordPosition,n);
		WordPosition += n;
	}
	return (n);
}



short 
UParser::input(void)
{
  short c;

  YY_DO_BEFORE_SCAN
  if (yy_c_buf_p == yy_e_buf_p) {
    short yy_n_chars;

    if (yy_saw_eof) {
      if (yywrap())
	 return (EOF);

      YY_INIT;
    }

    yy_b_buf_p = 0;
    YY_INPUT(yy_ch_buf, yy_n_chars, YY_MAX_LINE);

    if (yy_n_chars == YY_NULL) {
      yy_saw_eof = 1;

      if (yywrap())
	return (EOF);

      YY_INIT;
      return (input());
    }

    yy_c_buf_p = -1;
    yy_e_buf_p = yy_n_chars - 1;
  }

  c = yy_ch_buf[++yy_c_buf_p];

  YY_DO_BEFORE_ACTION;

  return (c);
} // input


void 
UParser::unput(char c)
{
    YY_DO_BEFORE_SCAN;

    if (yy_c_buf_p == 0) {
	register short i;
	register short yy_buf_pos = YY_BUF_MAX;

	for (i = yy_e_buf_p; i >= yy_c_buf_p; --i) {
	    yy_ch_buf[yy_buf_pos] = yy_ch_buf[i];
	    yy_st_buf[yy_buf_pos] = yy_st_buf[i];
	    --yy_buf_pos;
	}

	yy_c_buf_p = YY_BUF_MAX - yy_e_buf_p;
	yy_e_buf_p = YY_BUF_MAX;
    }

    if (yy_c_buf_p <= 0)
	YY_FATAL_ERROR(/* "flex scanner push-back overflow" */);

    if (yy_c_buf_p >= yy_b_buf_p && yy_ch_buf[yy_c_buf_p] == '\n')
	yy_ch_buf[yy_c_buf_p - 1] = '\n';

    yy_ch_buf[yy_c_buf_p--] = c;

    YY_DO_BEFORE_ACTION;
} // unput


short 
UParser::yylex()
{
	  register short yy_curst;
	  register char yy_sym;
	  short yy_n_chars, yy_lp, yy_iii, yy_buf_pos, yy_act, yy_full_match;
	
	  if (yy_init) {
	    YY_INIT;
	    yy_start = 1;
	    yy_init = 0;
	  }
	  goto get_next_token;
	
	do_action:
	  yy_full_match = yy_c_buf_p;
	
	  for ( ; ; )	{
	    YY_DO_BEFORE_ACTION
	
	    switch (yy_act) {
	case 1:
	{ BEGIN NORMAL;   if(!TestWord){K();SH();CH();}
			       else
			       if( (K() != (MATCH)) && (SH() != (MATCH)) && (CH() != (MATCH))) return (NOTMATCH);
			       PhonemePosition++; InitialPhoneme = Initial_CHORKORSH;}
		YY_BREAK
	case 2:
	{ BEGIN NORMAL;   if(!TestWord){Z();CH();}
			       else
			       if( (Z() != (MATCH)) &&  (CH() != (MATCH))) return (NOTMATCH);
			       PhonemePosition++; InitialPhoneme = Initial_CHORZ;}
		YY_BREAK
	case 3:
	{ BEGIN NORMAL;   if(!TestWord){Z();TS();}
			       else
			       if( (Z() != (MATCH)) && (TS() != (MATCH))) return (NOTMATCH);
			       PhonemePosition++; InitialPhoneme = Initial_TSORZ;}
		YY_BREAK
	case 4:
	{ BEGIN NORMAL;   if(!TestWord){TS();Z(); }
			       else
			       if((TS() != (MATCH)) && (Z() != (MATCH))) return (NOTMATCH);
			       PhonemePosition++; InitialPhoneme = Initial_TSORZ;}
		YY_BREAK
	  /* normals */
	case 5:
	{ BEGIN NORMAL;   if(!(CH())) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_CH;}
		YY_BREAK
	case 6:
	{ BEGIN NORMAL;   if(!(D())) return (NOTMATCH); PhonemePosition++;  InitialPhoneme  = Initial_D;}
		YY_BREAK
	case 7:
	{ BEGIN NORMAL;   if(!(F())) return (NOTMATCH); PhonemePosition++;  InitialPhoneme = Initial_F;}
		YY_BREAK
	case 8:
	{ BEGIN NORMAL;   if(!(G())) return (NOTMATCH); PhonemePosition++;  InitialPhoneme = Initial_G;}
		YY_BREAK
	case 9:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p + 1;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	{ BEGIN NORMAL;   if(!(H())) return (NOTMATCH); PhonemePosition++;  InitialPhoneme = Initial_H;}
		YY_BREAK
	case 10:
	{ BEGIN NORMAL;   if(!(J())) return (NOTMATCH); PhonemePosition++;  InitialPhoneme = Initial_J;}
		YY_BREAK
	case 11:
	case 12:
	{ BEGIN NORMAL;   if(!(K())) return (NOTMATCH); PhonemePosition++;  InitialPhoneme = Initial_K;}
		YY_BREAK
	case 13:
	{ BEGIN NORMAL;   if(!(L())) return (NOTMATCH); PhonemePosition++;  InitialPhoneme = Initial_L;}
		YY_BREAK
	case 14:
	case 15:
	case 16:
	case 17:
	{ BEGIN NORMAL;   if(!(N())) return (NOTMATCH); PhonemePosition++;  InitialPhoneme = Initial_N;}
		YY_BREAK
	case 18:
	case 19:
	{ BEGIN NORMAL;   if(!(R())) return (NOTMATCH); PhonemePosition++;  InitialPhoneme = Initial_R;}
		YY_BREAK
	case 20:
	case 21:
	case 22:
	{ BEGIN NORMAL;   if(!(T())) return (NOTMATCH); PhonemePosition++;  InitialPhoneme = Initial_T;}
		YY_BREAK
	case 23:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 24:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 25:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 26:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p + 1;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 27:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p + 1;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 28:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p + 1;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 29:
	case 30:
	{ BEGIN NORMAL;   if(!(S())) return (NOTMATCH); PhonemePosition++;  InitialPhoneme = Initial_S;}
		YY_BREAK
	case 31:
	case 32:
	{ BEGIN NORMAL;   if(!(SH())) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_SH;}
		YY_BREAK
	case 33:
	{ BEGIN NORMAL;   if(!TestWord) {TS();Z();}
			       else
			       if((TS() != (MATCH)) && (Z() != (MATCH))) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_TSORZ;}
		YY_BREAK
	case 34:
	{ BEGIN NORMAL;   if(!(W())) return (NOTMATCH); PhonemePosition++;  InitialPhoneme = Initial_W;}
		YY_BREAK
	    /* ex   | */
	case 35:
	{ BEGIN NORMAL;   if(!(Z())) return (NOTMATCH); PhonemePosition++;  InitialPhoneme = Initial_Z;}
		YY_BREAK
	 /* single duplicates */
	case 36:
	{ BEGIN NORMAL;   if(!TestWord) {CH();K();}
			       else
			       if( (CH() != (MATCH)) && (K()!= (MATCH)) ) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_CHORK;}
		YY_BREAK
	case 37:
	{ BEGIN NORMAL;   if(!TestWord) {J();G();}
			       else
			       if((J() != (MATCH)) && (G() != (MATCH))) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_JORG;}
		YY_BREAK
	case 38:
	{ BEGIN NORMAL;   if(!TestWord) {K();CH();}
			       else
			       if((K() != (MATCH)) && (CH() != (MATCH))) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_CHORK;}
		YY_BREAK
	case 39:
	{ BEGIN NORMAL;   if(!TestWord) {TS(); Z();}
			       else
			       if((TS() != (MATCH)) && (Z() != (MATCH))) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_TSORZ;}
		YY_BREAK
	 /* single normals */
	case 40:
	{ BEGIN NORMAL;   if(!B()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_B;}
		YY_BREAK
	case 41:
	{ BEGIN NORMAL;   if(!D()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_D;}
		YY_BREAK
	case 42:
	{ BEGIN NORMAL;   if(!F()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_F;}
		YY_BREAK
	case 43:
	{ BEGIN NORMAL;   if(!H()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_H;}
		YY_BREAK
	case 44:
	{ BEGIN NORMAL;   if(!J()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_J;}
		YY_BREAK
	case 45:
	{ BEGIN NORMAL;   if(!L()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_L;}
		YY_BREAK
	case 46:
	{ BEGIN NORMAL;   if(!M()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_M;}
		YY_BREAK
	case 47:
	{ BEGIN NORMAL;   if(!N()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_N;}
		YY_BREAK
	case 48:
	{ BEGIN NORMAL;   if(!P()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_P;}
		YY_BREAK
	case 49:
	{ BEGIN NORMAL;   if(!K()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_K;}
		YY_BREAK
	case 50:
	{ BEGIN NORMAL;   if(!R()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_R;}
		YY_BREAK
	case 51:
	{ BEGIN NORMAL;   if(!S()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_S;}
		YY_BREAK
	case 52:
	{ BEGIN NORMAL;   if(!T()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_T;}
		YY_BREAK
	case 53:
	{ BEGIN NORMAL;   if(!V()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_V;}
		YY_BREAK
	case 54:
	{ BEGIN NORMAL;   if(!W()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_W;}
		YY_BREAK
	case 55:
	case 56:
	{ BEGIN NORMAL;   if(!Z()) return (NOTMATCH); PhonemePosition++; InitialPhoneme = Initial_Z;}
		YY_BREAK
	case 57:
	{ BEGIN VOWEL; unput('a'); InitialPhoneme = Initial_VOWEL;}
		YY_BREAK
	case 58:
	{ BEGIN VOWEL; unput('e'); InitialPhoneme = Initial_VOWEL;}
		YY_BREAK
	case 59:
	{ BEGIN VOWEL; unput('i'); InitialPhoneme = Initial_VOWEL;}
		YY_BREAK
	case 60:
	{ BEGIN VOWEL; unput('o'); InitialPhoneme = Initial_VOWEL;}
		YY_BREAK
	case 61:
	{ BEGIN VOWEL; unput('u'); InitialPhoneme = Initial_VOWEL;}
		YY_BREAK
	case 62:
	{ BEGIN VOWEL; unput('y'); InitialPhoneme = Initial_VOWEL;}
		YY_BREAK
	case 63:
	
		YY_BREAK
	  /* duplicates */
	case 64:
	case 65:
	case 66:
	{ if(!TestWord) {K();CH();}
		       else
		       if((CH() != (MATCH)) && (K() != (MATCH))) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 67:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 68:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	{ if(!TestWord) {S();SH();}
		       else
		       if((S() != (MATCH)) && (SH() != (MATCH))) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 69:
	{ if(!TestWord) {K();SH();}
		       else
		       if((K() != (MATCH)) && (SH() != (MATCH))) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 70:
	{ if(!TestWord) {G();J();}
		       else
		       if((G() != (MATCH)) && (J() != (MATCH))) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 71:
	{ if(!TestWord) {T();D();}
		       else
		       if((T() != (MATCH)) && (D() != (MATCH))) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 72:
	{ if(!TestWord) {F();G();}
		       else
		       if((F() != (MATCH)) && (G() != (MATCH))) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	  /* normals */
	case 73:
	case 74:
	case 75:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	{  if(!CH()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 76:
	case 77:
	case 78:
	{  if(!D()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 79:
	case 80:
	case 81:
	case 82:
	{  if(!F()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 83:
	case 84:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	{  if(!G()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 85:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p + 1;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	{  if(!H()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 86:
	case 87:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	{  if(!J()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 88:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p + 1;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 89:
	case 90:
	case 91:
	case 92:
	case 93:
	case 94:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 95:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 96:
	case 97:
	{  if(!K()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 98:
	case 99:
	{  if(!L()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 100:
	case 101:
	case 102:
	case 103:
	{  if(!M()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 104:
	case 105:
	case 106:
	case 107:
	case 108:
	{  if(!N()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 109:
	{  if(!P()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 110:
	{  if(!(TestWord)) {T();}
			else
			if(T() != (MATCH)) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 111:
	case 112:
	case 113:
	case 114:
	{  if(!R()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 115:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 116:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p + 1;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 117:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p + 1;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 118:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p + 1;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 119:
	case 120:
	case 121:
	{  if(S()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 122:
	{  if(!TestWord) {S();PhonemePosition++;T();PhonemePosition--;}
			else
			if(S() != (MATCH)) return (NOTMATCH); PhonemePosition++;
			if(T() == (MATCH)) PhonemePosition++;
		     }
		YY_BREAK
	case 123:
	case 124:
	case 125:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 126:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p + 1;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 127:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p + 1;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 128:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 129:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	{  if(!SH()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 130:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	case 131:
	case 132:
	case 133:
	case 134:
	{  if(!T()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 135:
	case 136:
	{  if(!TS()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 137:
	{  if(!W()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 138:
	{  if(!V()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 139:
	{  if(!TS()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	 /* duplicates */
	case 140:
	{  if(!TestWord) {CH();K();}
			else
			if((CH() != (MATCH)) && (K()!= (MATCH))) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 141:
	{  if(!TestWord) {CH();K();}
			else
			if((CH() != (MATCH)) && (K() != (MATCH))) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 142:
	case 143:
	{  if(!TestWord) {D();T();}
			else
			if((D() != (MATCH)) && (T() != (MATCH))) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 144:
	{  if(!TestWord) {TS();S();}
			else
			if((TS() != (MATCH)) && (S() != (MATCH))) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 145:
	{  if(!(TestWord)) {G();J();}
			else
			if((G() != (MATCH)) && (J() != (MATCH))) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	 /* normals */
	case 146:
	{  if(!F()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 147:
	{  if(!H()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 148:
	{  if(!J()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 149:
	{  if(!L()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 150:
	{  if(!M()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 151:
	{  if(!N()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 152:
	{  if(!P()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 153:
	{  if(!K()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 154:
	{  if(!R()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 155:
	{  if(!S()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 156:
	{  if(!V()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 157:
	{  if(!W()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 158:
	{  if(!K()) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 159:
	{BEGIN VOWEL; unput('a');}
		YY_BREAK
	case 160:
	{BEGIN VOWEL; unput('e');}
		YY_BREAK
	case 161:
	{BEGIN VOWEL; unput('i');}
		YY_BREAK
	case 162:
	{BEGIN VOWEL; unput('o');}
		YY_BREAK
	case 163:
	{BEGIN VOWEL; unput('u');}
		YY_BREAK
	case 164:
	{BEGIN VOWEL; unput('y');}
		YY_BREAK
	case 165:
	{if(!TestWord) {EOW();}
		      else {
			if(EOW()) return (MATCH);
			PhonemePosition++;
			if(Ve()) {PhonemePosition++;if(EOW()) return (MATCH);}
			else return (NOTMATCH);
		      }
	             }
		YY_BREAK
	case 166:
	
		YY_BREAK
	  /* THIS ONE MIGHT NEED SOME ADJUSTMENT */
	case 167:
	{  if(!(TestWord)) {W();V1();}
		     else
		     if( (W() != (MATCH)) && (V1() != (MATCH))) return (NOTMATCH); PhonemePosition++;}
		YY_BREAK
	case 168:
	{ BEGIN NORMAL; if((TestWord) == FALSE) {V1();PhonemePosition++;Z();K();S();}
				   else {
				     if(!(V1())) return (NOTMATCH);
				     PhonemePosition++;
				     if( Z() != (MATCH)) {
				       if(K() != (MATCH)) {
					 if(S() != (MATCH)) return (NOTMATCH);}
				       }
				     }
				     PhonemePosition++;
				   }
		YY_BREAK
	case 169:
	case 170:
	{ if((Vet() != (MATCH))) return (NOTMATCH); else return (MATCH);}
		YY_BREAK
	case 171:
	{if(!TestWord) {V1();Ve();PhonemePosition++;EOW();}
		     else {
		       if((V1() != (MATCH))) return (NOTMATCH);}
		     }
		YY_BREAK
	case 172:
	{if(!TestWord) {V1();Ve();PhonemePosition++;T();PhonemePosition++;EOW();}
		     else   {
		       if((V1() != (MATCH))) return (NOTMATCH);
		       PhonemePosition++;
		       if((T() != (MATCH))) return (NOTMATCH);
		       PhonemePosition++;
		       if((EOW() != (MATCH))) return (NOTMATCH);
		       return (MATCH);}
		     }
		YY_BREAK
	case 173:
	{if(!TestWord) {V1();PhonemePosition++;EOW();}
			   else {
			     if( (V1()) != (MATCH) ) return (NOTMATCH);
			     PhonemePosition++;
			     if((EOW() != (MATCH))) return (NOTMATCH);
			     return (MATCH);} /* WORD ENDS WITH A VOWEL */
			   }
		YY_BREAK
	case 174:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	{ BEGIN NORMAL ; if(!V1()) return NOTMATCH; PhonemePosition++;}
		YY_BREAK
	case 175:
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
	yy_c_buf_p = yy_b_buf_p;
	YY_DO_BEFORE_ACTION; /* set up yytext again */
	{}; /* Match a vowel Note: This is a kludge,
	   if it isn't done like this, the whole thing crashes when more
	   than one consecutive vowel appears.  Shouldn't happen but, it does...
	   Weird huh? */
		YY_BREAK
	case 176:
	YY_DEFAULT_ACTION;
		YY_BREAK
	
	    case YY_NEW_FILE:
	      break;
	    case YY_END_TOK:
	      return (YY_END_TOK);
	    default:
	      YY_FATAL_ERROR(/*"fatal flex scanner internal error"*/);
	    }
	
	get_next_token:
	    YY_DO_BEFORE_SCAN
	
	    yy_curst = yy_start;
	
	    if (yy_ch_buf[yy_c_buf_p] == '\n')
	      ++yy_curst;
	
	    yy_b_buf_p = yy_c_buf_p + 1;
	
	    do {
	      if (yy_c_buf_p == yy_e_buf_p) {
		if (yy_e_buf_p >= YY_BUF_LIM) {
		  yy_n_chars = yy_e_buf_p - yy_b_buf_p;
	
		  if (yy_n_chars >= 0) {
		    for (yy_iii = 0; yy_iii <= yy_n_chars; ++yy_iii) {
		      yy_buf_pos = yy_b_buf_p + yy_iii;
		      yy_ch_buf[yy_iii] = yy_ch_buf[yy_buf_pos];
		      yy_st_buf[yy_iii] = yy_st_buf[yy_buf_pos];
		    }
		  }
	
		  yy_b_buf_p = 0;
		  yy_e_buf_p = yy_n_chars;
	
		  if (yy_e_buf_p >= YY_BUF_LIM)
		    YY_FATAL_ERROR(/*"flex input buffer overflowed"*/);
	
		    yy_c_buf_p = yy_e_buf_p;
		  } else if (yy_saw_eof) {
	saweof:
		  if (yy_b_buf_p <= yy_e_buf_p)
		    break;
		  if (yywrap())
		    yy_act = YY_END_TOK;
		  else {
		    YY_INIT;
		    yy_act = YY_NEW_FILE;
		  }
		  goto do_action;
		}
	
		YY_INPUT((yy_ch_buf + yy_c_buf_p + 1), yy_n_chars, YY_MAX_LINE);
	
		if (yy_n_chars == YY_NULL) {
		  if (yy_saw_eof)
		    YY_FATAL_ERROR(/*"flex scanner saw EOF twice - shouldn't happen"*/);
		  yy_saw_eof = 1;
		  goto saweof;
		}
	
		yy_e_buf_p += yy_n_chars;
	      }
	
	      ++yy_c_buf_p;
	      yy_sym = yy_ch_buf[yy_c_buf_p];
	
	      while (c[b[yy_curst] + yy_sym] != yy_curst)
		yy_curst = d[yy_curst];
	
	      yy_curst = n[b[yy_curst] + yy_sym];
	      yy_st_buf[yy_c_buf_p] = yy_curst;
	
	    } while (b[yy_curst] != YY_JAM_BASE);
	
	    if (yy_c_buf_p >= yy_b_buf_p) {
	      yy_curst = yy_st_buf[yy_c_buf_p];
	      yy_lp = l[yy_curst];
	
	find_rule:
	      for ( ; ; ) {
		if (yy_lp && yy_lp < l[yy_curst + 1]) {
		  yy_act = a[yy_lp];
		  goto do_action;
		}
	
		if (--yy_c_buf_p < yy_b_buf_p)
		  break;
	
		yy_curst = yy_st_buf[yy_c_buf_p];
		yy_lp = l[yy_curst];
	      }
	    }
	    ++yy_c_buf_p;
	
	    yy_act = YY_DO_DEFAULT;
	  }
} // YYLEX

/*
void InitRegexPattern()
      {
       #ifdef TRACE
       printf("\nInitRegexPattern()");
       #endif
       memset(RegexPattern,0,MAXREGEXPATTERNLENGTH);
      }

*/

void 
UParser::NewWord(char *Word)
{
	#ifdef TRACE
	printf("\nNewWord()");
	#endif
	strcat(Word,"\t");
	WordPosition = 0;
	WordLength = strlen(Word);
	WordPointer = Word;
	PhonemePosition = 1;
	YY_INIT;
	yy_init = 0;
	yy_start = 1;
	BEGIN INITIAL;
}

void 
UParser::CreatePhonPattern(char *Word)
{
   #ifdef TRACE
   printf("\nUParser :: CreatePhonPattern()");
   #endif
   Reset();
   TestWord = FALSE;
   NewWord(Word);
   yylex();
}

short 
UParser::PhonTestWord(char *Word)
{
	#ifdef TRACE
	printf("\nUParser :: TestWord()");
	#endif
	TestWord = TRUE;
	NewWord(Word);
	return (yylex());
}

